unit IWHTMLTag;
{PUBDIST}

interface

{$I IWCompilerDefines.inc}

uses
  Classes,
  IWColor, IWMarkupLanguageTag;

type
  TIWHTMLTag = class;

  TIWHTMLTagCollection = class(TIWMarkupLanguageTagCollection)
    function AddTagAsObject(const ATag: TIWHTMLTag;
      const ASetParentElement: Boolean = false): TIWHTMLTag; overload;
    function AddTag(const ATag: string; const ASetParentElement: Boolean = false): TIWHTMLTag; reintroduce;
  end;

  TIWHTMLTag = class(TIWMarkupLanguageTag)
  private
    function GetContents: TIWHTMLTagCollection;
  protected
    procedure SetTag(const Value: string); override;

    function ContentsClass: TIWMarkupLanguageTagCollectionClass; override;
  public
//added dummy parameter to remove compiler warning
    constructor CreateHTMLTag(const ATag: string; const AClosingTag: TIWCloseTag = cbTrue;
      const AParentElement: TIWMarkupLanguageElement = nil;const LDummy : Integer = 0);{$IFDEF VCL6ORABOVE}deprecated;{$ENDIF}
{$IFNDEF BCB}
    constructor Create(AParentTag: TIWMarkupLanguageElement);overload;override;
    constructor Create(const ATag: string; const AClosingTag: TIWCloseTag = cbTrue;
      const AParentElement: TIWMarkupLanguageElement = nil);overload;
{$ENDIF}
    property ClosingTag;
    property Contents: TIWHTMLTagCollection read GetContents;
  end;

  TIWHTMLTagClass = class of TIWHTMLTag;

implementation

uses
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  SysUtils,
  SWSystem;

const
  NeverClosedTags: String = 'area,br,frame,hr,img,input,link';

Var
  GClosingTagList: TStringList;


{ TIWHTMLTag }

function TIWHTMLTag.ContentsClass: TIWMarkupLanguageTagCollectionClass;
begin
  result := TIWHTMLTagCollection;
end;

{$IFNDEF BCB}
constructor TIWHTMLTag.Create(const ATag: string; const AClosingTag: TIWCloseTag = cbTrue;
  const AParentElement: TIWMarkupLanguageElement = nil);
begin
  inherited Create(AParentElement);
  FClosingTag := AClosingTag;
  Tag := ATag;
end;

constructor TIWHTMLTag.Create(AParentTag: TIWMarkupLanguageElement);
begin
  inherited Create(AParentTag);
end;
{$ENDIF}

constructor TIWHTMLTag.CreateHTMLTag(const ATag: string;
  const AClosingTag: TIWCloseTag;
  const AParentElement: TIWMarkupLanguageElement;
  const LDummy : Integer);
begin
  inherited Create(AParentElement);
  FClosingTag := AClosingTag;
  Tag := ATag;
end;

function TIWHTMLTag.GetContents: TIWHTMLTagCollection;
begin
  result := TIWHTMLTagCollection(inherited Contents);
end;

procedure TIWHTMLTag.SetTag(const Value: string);
begin
  inherited;

  if (GClosingTagList.IndexOf(Tag) > -1) or (FTag = '') then begin
    FClosingTag := cbFalse;
  end;

  if AnsiSameText('PRE', Tag) then begin
    IsPreformated := true;
  end;

  if AnsiSameText('A', Tag) then begin
    IsPreformated := true;
  end;

  if AnsiSameText('DIV', Tag) then begin
    IsPreformated := true;
  end;

  if AnsiSameText('TR', Tag) then begin
    IsPreformated := true;
  end;

  if AnsiSameText('TD', Tag) then begin
    IsPreformated := true;
  end;
end;

{ TIWHTMLTagCollection }

function TIWHTMLTagCollection.AddTag(const ATag: string;
  const ASetParentElement: Boolean): TIWHTMLTag;
begin
  result := TIWHTMLTag(inherited AddTag(ATag, ASetParentElement));
end;

function TIWHTMLTagCollection.AddTagAsObject(const ATag: TIWHTMLTag;
  const ASetParentElement: Boolean): TIWHTMLTag;
begin
  result := TIWHTMLTag(inherited AddTagAsObject(ATag, ASetParentElement));
end;

initialization
  GClosingTagList := TStringList.Create;
  GClosingTagList.Sorted := true;
  GClosingTagList.CommaText := NeverClosedTags;
finalization
  GClosingTagList.Free;
end.
